using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.ComponentModel.Design;
using System.Windows.Forms.Design;
using System.Text.RegularExpressions;


	/// <summary>
	/// Summary description for KParser.
	/// </summary>
	[ToolboxItem(true)]
	[System.Drawing.ToolboxBitmap(typeof(KParserComponent))] 
  //[System.Drawing.ToolboxBitmap(@"c:\me\me.ico")] 
	public class KParserComponent : System.ComponentModel.Component
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		NeuroneDescription[][] neurones=new NeuroneDescription[0][];
		TrainItemDescription[] trenovaci=new TrainItemDescription[0];
		TrainItemDescription[] testovaci=new TrainItemDescription[0];

		public KParserComponent():this(null)
		{
			
			
		}

		public KParserComponent(System.ComponentModel.IContainer container)
		{
			if (container!=null) container.Add(this);

			InitializeComponent();

      FakeNet();		
			
		}

		void FakeNet()
		{
			neurones=new NeuroneDescription[2][];
			for (int v=0;v<2; v++)
			{
				ArrayList work=new ArrayList();
				for (int f=0; f<3 -v/2; f++) work.Add(new NeuroneDescription("aa" + f.ToString()));
				
				neurones[v]=new NeuroneDescription[work.Count];
				work.CopyTo(0, neurones[v], 0, work.Count);
			}
			Trenovaci=new TrainItemDescription[]
				{
					new TrainItemDescription("1   2  3  1 ", 3),
					new TrainItemDescription("0,5 0  0  0", 3),
					new TrainItemDescription("0   0 -3  1 ", 3)
				};
			Testovaci=new TrainItemDescription[]
				{
					new TrainItemDescription("-1 -2.5  3  1 ", 3)
				};
		}

		public static double SmartParseDouble(string val)
		{
			double ret=0;
			if (val==null || val=="") return ret;

			try
			{
				ret=double.Parse(val);
			}
			catch (FormatException)
			{
				val=val.Replace(".", ",");
				ret=double.Parse(val);
			}
			return ret;

		}
		



		


		[System.ComponentModel.TypeConverter(typeof(NeuroneDescriptionArrayTypeConverter))]	
		[RefreshProperties(RefreshProperties.All)]
		[Category("Neurony")]
		public NeuroneDescription[] VstupniVrstva
		{
			get
			{
				if (neurones.Length<1) neurones=new NeuroneDescription[1][];
				return neurones[0];
			}
			set
			{
				if (value==null) throw new ArgumentNullException();
				if (neurones.Length<1) neurones=new NeuroneDescription[1][];
				neurones[0]=value;
				
			}
		}

		[System.ComponentModel.TypeConverter(typeof(NeuroneDescriptionArrayTypeConverter))]	
		[RefreshProperties(RefreshProperties.All)]
		[Category("Neurony")]
		public NeuroneDescription[] VystupniVrstva
		{
			get
			{
				if (neurones.Length<1) if (neurones.Length<1) neurones=new NeuroneDescription[1][];
				return neurones[neurones.GetLength(0)-1];
			}
			set
			{
        if (value==null) throw new ArgumentNullException();
				if (neurones.Length<1) neurones=new NeuroneDescription[1][];
				neurones[neurones.GetLength(0)-1]=value;
			}
		}

		

		[System.ComponentModel.TypeConverter(typeof(TrainItemDescriptionArrayTypeConverter))]	
		[RefreshProperties(RefreshProperties.All)]
		[Category("Trnovni")]
		public TrainItemDescription[] Trenovaci
		{
			get
			{
				return trenovaci;
			}
			set
			{
				if (value==null) throw new ArgumentNullException();
				trenovaci=value;
			}
		}

		[System.ComponentModel.TypeConverter(typeof(TrainItemDescriptionArrayTypeConverter))]	
		[RefreshProperties(RefreshProperties.All)]
		[Category("Trnovni")]
		public TrainItemDescription[] Testovaci
		{
			get
			{
				return testovaci;
			}
			set
			{
				if (value==null) throw new ArgumentNullException();
				testovaci=value;
			}
		}
		

		
		[System.ComponentModel.TypeConverter(typeof(NeuroneDescriptionArrayTypeConverter))]	
		[Category("Neurony")]
		public NeuroneDescription[][] VsechnyVrstvy
		{
			get
			{
				return neurones;
			}
		}

		

		[DefaultValue(2)]
		[Category("Vlastnosti")]
		[RefreshProperties(RefreshProperties.All)]
		public int PocetVrstev
		{
			get
			{
        return neurones.GetLength(0);
			}
			set
			{
				int v=value;
				if (v<0) throw new ArgumentOutOfRangeException("value", v.ToString());
				
				NeuroneDescription[][] newN=new NeuroneDescription[v][];
				for (int f=0; f< Math.Min(v, PocetVrstev); f++)//Prekopiruje puvodni hodnoty
				{
          newN[f]=neurones[f];					
				}
				neurones=newN;
			}
		}

		double kUceni=0.5; //Koeficient uceni
		[DefaultValue(0.5)]
		[Category("Vlastnosti")]
		[Description("Koeficient uen.")]
		public double KUceni
		{
			get {return kUceni;}
			set 
			{
				if (value <0 || value > 1) throw new ArgumentOutOfRangeException("value", value.ToString(), " musi byt mezi 0 a 1");
				kUceni=value;
			}

		}
		
		
		double kVlivu=0.5; //Koeficient vlivu z predchoziho kroku
		[DefaultValue(0.5)]
		[Category("Vlastnosti")]
		public double KVlivu
		{
			get {return kVlivu;}
			set 
			{
				if (value <0 || value > 1) throw new ArgumentOutOfRangeException("value", value.ToString(), " musi byt mezi 0 a 1");
				kVlivu=value;
			}

		}

		


		/*[DefaultValue(2)]
		[Category("Vlastnosti")]
		public int PocetVstupu
		{
			get
			{
				return VstupniVrstva.Length;
			}
			/*set
			{
				if (value<0) throw new ArgumentOutOfRangeException("value", value.ToString());
        

			}
		}*/

		
		
		FileStream inputStream=null;
		[Category("Vstup")]
		[Description("Obsah parosvanho souboru.")]
		[DefaultValue(null)]
		public Stream InputStream
		{
			get
			{
        return inputStream;        
			}
		}
		
		
		string inputFileName="";
		[EditorAttribute(typeof(System.Windows.Forms.Design.FileNameEditor), typeof(System.Drawing.Design.UITypeEditor))]
		[Category("Vstup")]
		[Description("Jmno souboru, kter se m parsovat.")]
		[DefaultValue("")]
		public string InputFile
		{
			get
			{
				return inputFileName;
			}
			set
			{
				if (value=="") return;
				if (!File.Exists(value)) throw new FileNotFoundException(value.ToString());
				inputFileName=value;
				if (inputStream!=null) inputStream.Close();
				inputStream=new FileStream(value.ToString(), FileMode.Open, FileAccess.ReadWrite, FileShare.ReadWrite);
				Parse(inputStream);
			}
		}

				

		/// <summary>
		/// Vrt dal neprzdn dek.
		/// </summary>
		private String getNextLine(StreamReader st) 
		{
			while(true) 
			{
				string line=st.ReadLine();

				if(line==null) return null;

				//odmazat mezery na zacatku a konci radku
				line=line.Trim();
				
				//osetrit komentare a prazdne radky
				if(line=="" || line.StartsWith("#")) continue;
				else return line;
			}
		}

		private static readonly char[] SPLIT=" ,.;\t".ToCharArray();
		public void Parse(Stream source)
		{
			StreamReader st=new StreamReader(source);			
			string line;
			int pocetVrstev;
			int pocetVstupu;
			
			NeuroneDescription[][] neurony;
			TrainItemDescription[] trenovaci;//trenovaci mnozina
			TrainItemDescription[] testovaci;//testovaci mnozina

			TypeConverter tc=TypeDescriptor.GetConverter(typeof(NeuroneDescription));
			//NeuroneDescription nd=(NeuroneDescription)tc.ConvertFrom(line);

			//pocet vrstev
			pocetVrstev=int.Parse(getNextLine(st));
			neurony=new NeuroneDescription[pocetVrstev+1][];//vrstvy vcetne vstupu

			//pocet vstupu
			pocetVstupu=int.Parse(getNextLine(st));
			neurony[0]=new NeuroneDescription[pocetVstupu];

			//popis vstupu
			for(int i=0; i<pocetVstupu ; i++) 
			{
				line=getNextLine(st);
				neurony[0][i]=(NeuroneDescription)tc.ConvertFrom(line);
			}

			//pocet neuronu v jednotlivych vrstvach
			line=getNextLine(st);
			String[] counts=line.Split(SPLIT);
			for(int i=0;i<pocetVrstev;i++)
			{
				neurony[i+1]=new NeuroneDescription[int.Parse(counts[i])];
			}

			//popis vystupu
			for(int i=0;i<neurony[pocetVrstev].Length;i++)  //vystupni vrstva
			{
				line=getNextLine(st);
				neurony[pocetVrstev][i]=(NeuroneDescription)tc.ConvertFrom(line);
			}

			//Koeficient uceni
			kUceni=KParserComponent.SmartParseDouble(getNextLine(st));
			kVlivu=KParserComponent.SmartParseDouble(getNextLine(st));

			//-- Trenovaci mnozina
			//pocet prvku
			trenovaci=new TrainItemDescription[int.Parse(getNextLine(st))];

			//Jednotlive Prvky
			for(int i=0;i<trenovaci.Length;i++) 
			{
				line=getNextLine(st);
				trenovaci[i]=new TrainItemDescription(line, pocetVstupu);
			}

			//-- Testovaci mnozina
			//pocet prvku
			testovaci=new TrainItemDescription[int.Parse(getNextLine(st))];

			//Jednotlive Prvky
			for(int i=0;i<testovaci.Length;i++) 
			{
				testovaci[i]=new TrainItemDescription(line, pocetVstupu);
			}


			//vytvorit vnitrni neurony
			for(int i=1;i<neurony.Length-1;i++)
			{
				for(int j=0;j<neurony[i].Length;j++) 
				{
					neurony[i][j]=new NeuroneDescription(String.Format("Vnitrni_{0}_{1}",i,j));
				}
			}

			this.neurones=neurony;
			this.testovaci=testovaci;
			this.trenovaci=trenovaci;
		}

		

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{

		}
		#endregion
	}

