using System;

/// <summary>
/// 
/// </summary>
[System.ComponentModel.TypeConverter(typeof(NeuroneDescriptionTypeConverter))]	
public class NeuroneDescription
{
	/// <summary> Jmno tohoto neuronu. </summary>
	private string name="";

	/// <summary> Minimln hodnota. </summary>
	private double min=0.0;

	/// <summary> Maximln hodnota. </summary>
	private double max=1.0;

	public NeuroneDescription() : this("")
	{
	}

	public NeuroneDescription(string name)
	{
		this.name=name;			
	}


	/// <summary>
	/// Jmno tohoto neuronu.
	/// </summary>
	public string Name
	{
		get
		{
			return name;
		}
		set
		{
			name=value;
		}
	}

	/// <summary>
	/// Maximln hodnota.
	/// </summary>
	public double Max
	{
		get 
		{
			return max;
		}
		set
		{
			this.max=value;
			if (Min>max) min=max;
		}
	}

	/// <summary>
	/// Minimln hodnota.
	/// </summary>
	public double Min
	{
		get 
		{
			return min;
		}
		set
		{
			this.min=value;
			if (min>Max) max=min;
		}
	}

	public override string ToString()
	{
		return string.Format("{0} <{1}  {2} >", Name, min, max);
	}
}
