using System;
using System.ComponentModel;
using System.Text.RegularExpressions;
using System.Reflection;


	/// <summary>
	/// 
	/// </summary>
internal class NeuroneDescriptionTypeConverter :  ExpandableObjectConverter
{
	
	public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
	{
		if (sourceType == typeof(string)) return true;
		return base.CanConvertFrom(context, sourceType);
	}

	

	public override object ConvertFrom(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value)
	{
		string st=value as string;
		//if (st==null) return base.ConvertFrom (context, culture, value);
		if (st==null) throw new ArgumentException("String na konverzi na NDescriptor je null nebo neni string");
		
		//Regex r=new Regex(@"\s*(?'Name'\w+)[.;:,\s<]+(?'Min'\w+)[;:\s]+(?'Max'\w+)[;:\s\n>]*", RegexOptions.Singleline);
		Regex r=new Regex(@"\s*(?'Name'\w+)([.;:,\s<]+(?'Min'-?[\w.,]+)[;:\s]+(?'Max'-?[\w.,]+)[;:\s\n>]*)?", RegexOptions.Singleline);

		Match m=r.Match(st);
		//if (!m.Success) return base.ConvertFrom (context, culture, value);
		//if (m.Groups.Count<1) base.ConvertFrom (context, culture, value);

		if (!m.Success || m.Groups.Count<1) throw new ArgumentException("Nepovedlo se parsovani stringu na MDescriptor");

		NeuroneDescription nd=new NeuroneDescription();
		
		nd.Name=m.Groups["Name"].Value;

		//try {nd.Max=double.Parse(m.Groups["Max"].Value); }  catch{}
		//try {nd.Min=double.Parse(m.Groups["Min"].Value); }  catch{}

		nd.Max=KParserComponent.SmartParseDouble(m.Groups["Max"].Value);
		nd.Min=KParserComponent.SmartParseDouble(m.Groups["Min"].Value);

		return nd;						
	}
}