using System;
using System.Text.RegularExpressions;
using System.Text;
/// <summary>
/// Jeden vstup v trenovaci nebo testovaci mnozine.
/// </summary>
[System.ComponentModel.TypeConverter(typeof(TrainItemDescriptionTypeConverter))]
public class TrainItemDescription
{

	/// <summary> Vstupy. </summary>
	private double[] vstupy=new double[0];

	/// <summary> Oekvan vstupy. </summary>
	private double[] vystupy=new double[0];

	/// <summary>
	/// Vstupy.
	/// </summary>
	[System.ComponentModel.TypeConverter(typeof(TrainItemDescriptionArrayTypeConverter))]	
	public double[] Vstupy
	{
		get{return vstupy;}
		set
		{

			vstupy=value!=null ? value : new double[0];
		}
	}

	/// <summary>
	/// Oekvan vstupy.
	/// </summary>
	[System.ComponentModel.TypeConverter(typeof(TrainItemDescriptionArrayTypeConverter))]	
	public double[] Vystupy
	{
		get{return vystupy;}
		set{vystupy=value!=null ? value : new double[0];}
	}

	public TrainItemDescription()
	{

	}

	/// <summary>
	/// Vytvo nov pedmt do testovac/trnovac mnoiny.
	/// </summary>
	/// <param name="line">dek, kter se m rozparsovat.</param>
	/// <param name="pocetVstupu">
	/// Kolik je v sti vstup (zbytek jsou vstupy).
	/// </param>
	public TrainItemDescription(String line, int pocetVstupu) 
	{
		//String[] test=line.Split(SPLIT);
		MatchCollection m=new Regex(@"\s*(-?[\d]*[,.]?[\d]+)+\s*").Matches(line);
		//if(!m.Success) return;
		
		int pocetcelkem=m.Count;
		
		vstupy=new double[pocetVstupu];
		vystupy=new double[pocetcelkem-pocetVstupu];


		

		int i=0;
		for(;i<pocetVstupu;i++) 
		{
			vstupy[i]=KParserComponent.SmartParseDouble(m[i].Value);
		}

		for(;i<pocetcelkem;i++) 
		{
			vystupy[i-pocetVstupu]=KParserComponent.SmartParseDouble(m[i].Value);
		}
	}

	public override string ToString()
	{
		StringBuilder sb=new StringBuilder("( ");
		for (int f=0; f<Vstupy.Length; f++)
		{
			sb.Append(Vstupy[f].ToString());
			sb.Append("  ");
		}
		sb.Append(")  -> ( ");

		for (int f=0; f<Vystupy.Length; f++)
		{
			sb.Append(Vystupy[f].ToString());
			sb.Append("  ");
		}
		sb.Append(")");
		return sb.ToString();
		
	}




}

