using System;
using System.ComponentModel;
using System.Text.RegularExpressions;


	/// <summary>
	/// 
	/// </summary>
internal class TrainItemDescriptionTypeConverter : ExpandableObjectConverter
{
	
	public override object ConvertTo(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value, Type destinationType)
	{
		if (value==null) return base.ConvertTo(context,culture, value, destinationType);
		return value.ToString();
	}

	public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
	{
		if (sourceType == typeof(string)) return true;
		return base.CanConvertFrom(context, sourceType);
	}

	

	public override object ConvertFrom(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value)
	{
		string st=value as string;
		if (st==null) throw new ArgumentException("String na konverzi na NDescriptor je null nebo neni string");
		
		TrainItemDescription tid=new TrainItemDescription();

		string[] s=Regex.Split(st, @"\s*->\s*");
		
		
    if (s.Length==0) return new TrainItemDescription();
	
		string vstupniSt=s[0];
		string vystupniSt;
		if (s.Length==1)	vystupniSt="";
		else 							vystupniSt=s[1];
		
		Regex r=new Regex(@"[\s\)\(]*(?'Cislo'-?[\d]*[,\.]?[\d]+)+[;:\s\)\(]*");
		MatchCollection vstupni=r.Matches(vstupniSt);
		MatchCollection vystupni=r.Matches(vystupniSt);
	
    
		tid.Vstupy=new double[vstupni.Count];
		tid.Vystupy=new double[vystupni.Count];
    
		
		
		for(int i=0; i<vstupni.Count;i++) 
		{
			tid.Vstupy[i]=KParserComponent.SmartParseDouble(vstupni[i].Groups["Cislo"].Value);
		}

		for(int i=0;i<vystupni.Count;i++) 
		{
			tid.Vystupy[i]=KParserComponent.SmartParseDouble(vystupni[i].Groups["Cislo"].Value);
		}

    return tid;		
	}

	


}

